package imi.pmf.shop;

import imi.pmf.shop.interfaces.IInventoryService;
import imi.pmf.shop.interfaces.IOrderRepository;
import imi.pmf.shop.interfaces.IPaymentProcessor;

public class OrderService {

    private IPaymentProcessor paymentProcessor;
    private IInventoryService inventoryService;
    private IOrderRepository orderRepository;

    public OrderService(IPaymentProcessor paymentProcessor,
                        IInventoryService inventoryService,
                        IOrderRepository orderRepository) {
        this.paymentProcessor = paymentProcessor;
        this.inventoryService = inventoryService;
        this.orderRepository = orderRepository;
    }

    public boolean placeOrder(Order order) {
        if (!inventoryService.isInStock(order.getProductId(), order.getQuantity())) {
            return false;
        }
        if (!paymentProcessor.processPayment(order.getProductId(), order.getTotalPrice())) {
            return false;
        }
        order.setProcessed(true);
        orderRepository.saveOrder(order);
        return true;
    }

    public boolean applyDiscountAndPlaceOrder(Order order) {
        double total = order.getTotalPrice();
        double discount = 0;

        if (order.getQuantity() > 5) discount += 0.10; // 10% popusta
        if (total > 200) discount += 0.05; // dodatnih 5% popusta

        double discountedTotal = total * (1 - discount);

        if (!inventoryService.isInStock(order.getProductId(), order.getQuantity())) {
            return false;
        }
        if (!paymentProcessor.processPayment(order.getProductId(), discountedTotal)) {
            return false;
        }

        order.setProcessed(true);
        orderRepository.saveOrder(order);
        return true;
    }
}
